<?php

if (!function_exists('tokenize')) {
    function tokenize($data, $method_type = 'POST')
    {
        $api_key = $_SERVER['CHANNEX_PCI_API_KEY'];
        $api_url = 'https://pci.channex.io/api/v1/cards?api_key=' . $api_key;
        $method_type = 'POST';

        $card_type = get_credit_card_type($data['card']['card_number']);

        if ($card_type) {
            $data['card']['card_type'] = $card_type;
        }

        $headers = array(
            "Content-Type: application/json",
        );

        $response = call_api($api_url, $data, $headers, $method_type);

        $response = json_decode($response, true);
        return $response;
    }
}

function get_cc_cvc_encrypted($cvc = null, $token = null)
{
    if ($cvc && is_numeric($cvc) && $token) {
        $CI = &get_instance();
        $CI->load->library('Encrypt');

        $cc_cvc_encrypted = $CI->encrypt->encode($cvc, $token); // get encoded cvc
        return $cc_cvc_encrypted;
    }
    return null;
}

function send_payment_request($url, $card_token, $data, $headers, $method_type = 'POST')
{

    $api_key = $_SERVER['CHANNEX_PCI_API_KEY'];

    $url = urlencode($url);

    $api_url = 'https://pci.channex.io/api/v1/cards/' . $card_token . '/send?api_key=' . $api_key . '&method=post&url=' . $url;
    $method_type = 'POST';

    $response = call_api($api_url, $data, $headers, $method_type);

    $response = json_decode($response, true);

    return $response;
}

function send_payment_request_for_authorize_net($url, $card_token, $data, $headers, $method_type = 'POST')
{

    $api_key = $_SERVER['CHANNEX_PCI_API_KEY'];

    $url = urlencode($url);

    $api_url = 'https://pci.channex.io/api/v1/cards/' . $card_token . '/send?api_key=' . $api_key . '&method=post&url=' . $url;
    $method_type = 'POST';

    $response = call_api($api_url, $data, $headers, $method_type);

    $response = preg_replace('/^\xEF\xBB\xBF/', '', $response);

    $response = json_decode($response, true);

    return $response;
}

function send_card_request($url, $card_token, $data, $headers, $method_type = 'POST', $is_json_format = true)
{

    $api_key = getenv('CHANNEX_PCI_API_KEY');

    $url = urlencode($url);

    $api_url = 'https://pci.channex.io/api/v1/cards/' . $card_token . '/send?api_key=' . $api_key . '&method=post&url=' . $url;
    $method_type = 'POST';

    $response = call_api($api_url, $data, $headers, $method_type, $is_json_format);

    $response = json_decode($response, true);

    return $response;
}

function retrieve_booking($url, $headers, $method_type = 'POST', $data = array())
{

    $api_key = getenv('CHANNEX_PCI_API_KEY');

    $url = urlencode($url);

    $api_url = 'https://pci.channex.io/api/v1/capture?api_key=' . $api_key . '&method=get&url=' . $url . '&profile=channex';

    $response = call_api($api_url, $data, $headers, $method_type);

    $response = json_decode($response);

    return $response;
}

function show_cc_details($card_token)
{

    $api_key = $_SERVER['CHANNEX_PCI_API_KEY'];

    $headers = array(
        "Content-Type: application/json",
    );

    $session_token_card_response = get_session_token_for_card($api_key, $headers);
    if (
        isset($session_token_card_response['data']) &&
        isset($session_token_card_response['data']['attributes']) &&
        isset($session_token_card_response['data']['attributes']['session_token']) &&
        $session_token_card_response['data']['attributes']['session_token']
    ) {
        $session_token = $session_token_card_response['data']['attributes']['session_token'];
    }

    $session_token_service_code_response = get_session_token_for_service_code($api_key, $headers);
    if (
        isset($session_token_service_code_response['data']) &&
        isset($session_token_service_code_response['data']['attributes']) &&
        isset($session_token_service_code_response['data']['attributes']['session_token']) &&
        $session_token_service_code_response['data']['attributes']['session_token']
    ) {
        $service_code_token = $session_token_service_code_response['data']['attributes']['session_token'];
    }

    if ($session_token && $service_code_token) {
        $api_url = 'https://pci.channex.io/api/v1/show_card?card_token=' . $card_token . '&session_token=' . $session_token . '&service_code_token=' . $service_code_token;

        $response = call_api($api_url, array(), array(), 'GET');

        // $response = json_decode($response);

        return $response;
    }
}

function get_session_token_for_card($api_key, $headers)
{

    $api_url = 'https://pci.channex.io/api/v1/session_tokens?api_key=' . $api_key;

    $data = array(
        "session_token" => array(
            "scope" => "show_card",
        ),
    );

    $response = call_api($api_url, $data, $headers, 'POST');

    $response = json_decode($response, true);

    return $response;
}

function get_session_token_for_service_code($api_key, $headers)
{

    $api_url = 'https://pci.channex.io/api/v1/session_tokens?api_key=' . $api_key;

    $data = array(
        "session_token" => array(
            "scope" => "show_service_code",
        ),
    );

    $response = call_api($api_url, $data, $headers, 'POST');

    $response = json_decode($response, true);

    return $response;
}

if (!function_exists('get_credit_card_type')) {
    function get_credit_card_type($cardNumber)
    {
        // Remove non-digits from the number
        $cardNumber = preg_replace('/\D/', '', $cardNumber);

        // Validate the length
        $len = strlen($cardNumber);
        if ($len < 15 || $len > 16) {
            throw new Exception("Invalid credit card number. Length does not match");
        } else {
            switch ($cardNumber) {
                case (preg_match('/^4/', $cardNumber) >= 1):
                    return 'Visa';
                case (preg_match('/^5[1-5]/', $cardNumber) >= 1):
                    return 'Master';
                case (preg_match('/^2/', $cardNumber) >= 1):
                    return 'Master';
                case (preg_match('/^3[47]/', $cardNumber) >= 1):
                    return 'Amex';
                case (preg_match('/^3(?:0[0-5]|[68])/', $cardNumber) >= 1):
                    return 'Diners';
                case (preg_match('/^6(?:011|5)/', $cardNumber) >= 1):
                    return 'Discover';
                case (preg_match('/^(?:2131|1800|35\d{3})/', $cardNumber) >= 1):
                    return 'JCB';
                default:
                    throw new Exception("Could not determine the credit card type.");
                    break;
            }
        }
    }

}

if (!function_exists('call_api')) {
    function call_api($api_url, $data, $headers, $method_type = 'POST', $is_json_format = true)
    {

        $url = $api_url;

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        if ($method_type == 'GET') {

        } else {
            curl_setopt($curl, CURLOPT_POST, 1);

            if($is_json_format)
                curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
            else
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        }

        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($curl);

        curl_close($curl);

        return $response;
    }
}

function nestpay_send_card_request($url, $card_token, $data, $headers, $method_type = 'POST')
{
    $api_key = $_SERVER['CHANNEX_PCI_API_KEY'];

    $api_url = 'https://pci.channex.io/api/v1/cards/' . $card_token . '/send?api_key=' . $api_key . '&method=post&url=' . $url;
    $method_type = 'POST';

    $response = nestpay_call_api($api_url, $data, $headers, $method_type);

     //$response = json_encode($response, true);

    return $response;
}

if (!function_exists('nestpay_call_api')) {
    function nestpay_call_api($api_url, $data, $headers, $method_type = 'POST'){

        $url = $api_url;
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($curl);
        // if (curl_errno($ch)) {
        // $errorCode = curl_errno($ch);
        // $errorMessage = curl_error($ch);
        // echo "cURL error code: $errorCode\n";
        // echo "cURL error message: $errorMessage\n";
        // }
        curl_close($curl);
        return $response;
    }
}
